    MAC PINWHEEL_VARS
top     ds  1
line    ds  1
leor    ds  1
reor    ds  1
ly      ds  1
ry      ds  1
lyx     ds  1
ryx     ds  1
pf0l    ds  1
pf1l    ds  1
pf2l    ds  1
pf0r    ds  1
pf1r    ds  1
pf2r    ds  1
spritec ds  1   ;sprite counter
spriteh ds  1   ;sprite height
grp0ptr ds  2
grp1ptr ds  2
    ENDM

LONGGREET   equ 1   ;"greetings" vs "greets"

WAMMAH      equ 27
TRILOBITH   equ 37
TRSIH       equ 25
JACH        equ 23
#if LONGGREET
GREETH      equ 47
#else
GREETH      equ 32
#endif
MSBH        equ 19
NOICEH      equ 22
PWPH        equ 13

    MAC GREETDATA
GreetData
Wamma
    .byte %00000000

    .byte %10001000
    .byte %10001000
    .byte %11111000
    .byte %01010000
    .byte %00100000

    .byte %00000000
    .byte %10001000
    .byte %10001000
    .byte %10101000
    .byte %11011000
    .byte %10001000

    .byte %00000000
    .byte %10001000
    .byte %10001000
    .byte %10101000
    .byte %11011000
    .byte %10001000

    .byte %00000000
    .byte %10001000
    .byte %10001000
    .byte %11111000
    .byte %01010000
    .byte %00100000

    .byte %00000000
    .byte %01010000
    .byte %10101000
    .byte %10001000

Trilobit
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %01110000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %00000000

    .byte %01100000
    .byte %01010000
    .byte %01100000
    .byte %01000000
    .byte %00000000

    .byte %00100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00100000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00010000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %01110000
    .byte %00100000

Trsi
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %00000000
    .byte %00000000

    .byte %01110000
    .byte %10001000
    .byte %00010000
    .byte %00100000
    .byte %01000000
    .byte %10001000
    .byte %01110000
    .byte %00000000

    .byte %10001000
    .byte %10001000
    .byte %11110000
    .byte %10001000
    .byte %11110000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00100000
    .byte %00100000
    .byte %11111000

Jac
    .byte %00000000

    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %01110000
    .byte %01110000
    .byte %00000000

    .byte %01110000
    .byte %10001000
    .byte %10000000
    .byte %10001000
    .byte %01110000
    .byte %00000000

    .byte %10001000
    .byte %10001000
    .byte %11111000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %01110000
    .byte %10001000
    .byte %00001000
    .byte %00001000
    .byte %11111000

Greets
    .byte %00000000

    .byte %01100000
    .byte %00010000
    .byte %00100000
    .byte %01000000
    .byte %00110000
    .byte %00000000

#if LONGGREET
    .byte %01100000
    .byte %00010000
    .byte %00110000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %01010000
    .byte %01010000
    .byte %01100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %00000000
#endif

    .byte %00100000
    .byte %00100000
    .byte %01110000
    .byte %00100000
    .byte %00000000

    .byte %00110000
    .byte %01000000
    .byte %01100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %00110000
    .byte %01000000
    .byte %01100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00010000
    .byte %00000000

    .byte %00100000
    .byte %01010000
    .byte %01010000
    .byte %01000000
    .byte %00110000

Msb
    .byte %00000000

    .byte %11110000
    .byte %10001000
    .byte %11110000
    .byte %10001000
    .byte %11110000
    .byte %00000000

    .byte %01110000
    .byte %10001000
    .byte %00010000
    .byte %00100000
    .byte %01000000
    .byte %10001000
    .byte %01110000
    .byte %00000000

    .byte %10001000
    .byte %10001000
    .byte %10101000
    .byte %11011000
    .byte %10001000

Noice
    .byte %00000000

    .byte %00110000
    .byte %01000000
    .byte %01100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %00110000
    .byte %01000000
    .byte %00110000
    .byte %00000000

    .byte %00100000
    .byte %00100000
    .byte %00000000
    .byte %00100000
    .byte %00000000

    .byte %00100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %01010000
    .byte %01010000
    .byte %01100000

Pwp
    .byte %00000000

    .byte %01000000
    .byte %01100000
    .byte %01010000
    .byte %00100000
    .byte %00000000

    .byte %01010000
    .byte %10101000
    .byte %10001000
    .byte %00000000

    .byte %01000000
    .byte %01100000
    .byte %01010000
    .byte %00100000

    .byte %00000000
    ENDM

    MAC PINWHEEL_LOGIC
GreetH
    .byte WAMMAH+1
    .byte TRILOBITH+1
    .byte TRSIH+1
    .byte JACH+1
    .byte GREETH+1
    .byte MSBH+1
    .byte NOICEH+1
    .byte PWPH+1

GreetBK
    .byte #$9A
    .byte #$4A
    .byte #$0A
    .byte #$3A
    .byte #$2A
    .byte #$CA
    .byte #$5A
    .byte #$8A

GreetPF
    .byte #$6A
    .byte #$BA
    .byte #$2A
    .byte #$CA
    .byte #$DA
    .byte #$3A
    .byte #$AA
    .byte #$0A

GreetPtrL
    .byte #<Wamma
    .byte #<Trilobit
    .byte #<Trsi
    .byte #<Jac
    .byte #<Greets
    .byte #<Msb
    .byte #<Noice
    .byte #<Pwp

GreetPtrH
    .byte #>Wamma
    .byte #>Trilobit
    .byte #>Trsi
    .byte #>Jac
    .byte #>Greets
    .byte #>Msb
    .byte #>Noice
    .byte #>Pwp

PinwheelLogic
    lda #1
    sta CTRLPF

    lda #0
    sta pf0l
    sta pf1l
    sta pf2l
    sta pf0r
    sta pf1r
    sta pf2r

    lda beat
    and #$0F
    tax
    lda EorTab,X
    sta leor

    lda beat
    eor #$FF
    clc
    adc #ROFS
    and #$0F
    tax
    lda EorTab,X
    sta reor

    lda beat
    asl
    asl
    asl
    asl
    asl
    and #%11100000
    sec
    sbc #4
    sta ly
    dec ly

    lda beat
    eor #$FF
    clc
    adc #ROFS
    asl
    asl
    asl
    asl
    asl
    and #%11100000
    sec
    sbc #4
    sta ry
    dec ry

    lda #1
    sta top
    sta ryx
    lda #0
    sta lyx

    lda measure
    sec
    sbc #INTROLEN-4
    and #7
    tax
    lda GreetH,X
    sta spriteh
    lda GreetBK,X
    sta COLUBK
    lda GreetPF,X
    sta COLUPF
    lda #GreetPtrL,X
    sta grp0ptr
    sta grp1ptr
    inc grp1ptr
    lda #GreetPtrH,X
    sta grp0ptr+1
    sta grp1ptr+1

    lda frame
    asl
    tax
    lda SinTab,X
    lsr
    lsr
    lsr
    clc
    adc spriteh
    lsr
    clc
    adc #20
    sta spritec

    ldx #0
    lda #73
    jsr PositionObject
    ldx #1
    lda #74
    jsr PositionObject

    lda #$00
    sta COLUP1
    lda #$0F
    sta COLUP0

    lda #7
    sta NUSIZ0
    sta NUSIZ1

    sta WSYNC
    sta HMOVE

    rts
    ENDM

    MAC PINWHEEL_KERNEL
EorTab
    .byte $FF
    .byte $00
    .byte $00
    .byte $00
    .byte $00
    .byte $00
    .byte $00
    .byte $00

    .byte $00
    .byte $FF
    .byte $FF
    .byte $FF
    .byte $FF
    .byte $FF
    .byte $FF
    .byte $FF

ROFS    equ 2

PinwheelKernel
    ldx lyx
    ldy ly,X
    lda #27
    sta line
PinwheelKernel_Loop
    sta WSYNC

    lda PinwheelQ2PF0,Y
    eor leor
    sta PF0
    sta pf0l
    lda PinwheelQ2PF1,Y
    eor leor
    sta PF1
    sta pf1l
    lda PinwheelQ2PF2,Y
    eor leor
    sta PF2
    sta pf2l

    lda pf2r
    ldy pf1r
    sta.w PF2
    sty PF1
    lda pf0r
    sta PF0

    ldx ryx
    ldy ly,X

    sta WSYNC

    lda pf0l
    sta PF0
    lda pf1l
    sta PF1
    lda pf2l
    sta PF2

    ldx PinwheelQ2PF0,Y
    txs

    lda PinwheelQ2PF1,Y
    eor reor
    tax
    lda PinwheelQ2PF2,Y
    stx PF1
    stx pf1r

    eor reor
    sta PF2     ;15 px = 5 cy late
    sta pf2r

    tsx
    txa
    eor reor
    sta PF0
    sta pf0r

    dec spritec

    sta WSYNC

    lda pf0l
    sta PF0
    lda pf1l
    sta PF1
    lda pf2l
    sta PF2

    lda ryx
    beq Whoop
    dec ry
    jmp Wheep
Whoop
    inc ly
    nop
Wheep

    lda pf0r
    sta PF0
    lda pf1r
    sta PF1
    lda pf2r
    sta PF2

    SLEEP 2

    ldy spritec
    cpy spriteh
    bcc PinwheelKernel_Sprite

    SLEEP 6
    lda #0
    sta GRP0
    sta GRP1
    jmp PinwheelKernel_SpriteDone

PinwheelKernel_Sprite
    lda (grp0ptr),Y
    sta GRP0
    lda (grp1ptr),Y
    sta GRP1

PinwheelKernel_SpriteDone
    ldx lyx
    bne Whoop2
    dec ly,X
    jmp Wheep2
Whoop2
    nop
    inc ly,X
Wheep2

    lda pf0l
    sta PF0
    lda pf1l
    sta PF1
    lda pf2l
    sta PF2

    lda pf0r
    sta PF0
    lda pf1r
    sta PF1
    lda pf2r
    sta PF2

    ldy ly,X

    dec line
    bmi PinwheelKernel_Next
    jmp PinwheelKernel_Loop

PinwheelKernel_Next
    dec top
    bmi PinwheelKernel_DoBurn

    lda pf2l
    sta PF2
    lda pf1l
    sta PF1
    lda pf0l
    sta PF0

    lda #1
    sta lyx
    lda #0
    sta ryx
    inc ly
    inc ry

    lda pf0r
    sta PF0
    lda pf1r
    sta PF1
    lda pf2r
    sta PF2

    jmp PinwheelKernel

PinwheelKernel_DoBurn
    ldx #LINES-32*7
PinwheelKernel_Burn
    sta WSYNC
    lda #0
    sta PF0
    sta PF1
    sta PF2
    sta GRP0
    sta GRP1
    dex
    bne PinwheelKernel_Burn

PinwheelKernel_Done
    ldx #$FF
    txs
    jmp DoneKernel
    ENDM
